def solve():
    # Вхідні дані
    n = int(input())
    a = list(map(str, input().split()))
    
    # Сортуємо числа за довжиною, щоб коротші числа розглядати першими
    a.sort(key=lambda x: len(x))
    
    # Підмножини, які будемо формувати
    subsets = []
    
    # Функція для пошуку числа в усіх підмножинах
    def add_to_subsets(number):
        for subset in subsets:
            # Перевіряємо, чи є в середині підмножини префікс
            if any(number.startswith(str(x)) for x in subset):
                subset.append(int(number))
                return
        # Якщо не знайшли підмножину, де число є префіксом, створюємо нову підмножину
        subsets.append([int(number)])

    # Додаємо числа по черзі
    for num in a:
        add_to_subsets(num)
    
    # Виводимо кількість підмножин
    print(len(subsets))
    
    # Виводимо кожну підмножину
    for subset in subsets:
        print(len(subset))
        print(" ".join(map(str, subset)))